/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.dtd;

import com.sun.tools.xjc.dtd.parser.DTDParseException;
import com.sun.tools.xjc.dtdx.DXAttribute;
import com.sun.tools.xjc.dtdx.DXElement;

public class Attribute {
    private String name;
    private String type;
    private String[] values;
    private String defaultValue;
    private boolean isFixed;
    private boolean isRequired;
    public static final String CDATA = "CDATA";
    public static final String ID = "ID";
    public static final String IDREF = "IDREF";
    public static final String IDREFS = "IDREFS";
    public static final String ENTITY = "ENTITY";
    public static final String ENTITIES = "ENTITIES";
    public static final String NMTOKEN = "NMTOKEN";
    public static final String NMTOKENS = "NMTOKENS";
    public static final String NOTATION = "NOTATION";
    public static final String ENUMERATION = "ENUMERATION";

    public Attribute(String string) {
        this.name = string;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public boolean isDefaulted() {
        return this.defaultValue != null && !this.isFixed;
    }

    public void setIsFixed(boolean bl) {
        this.isFixed = bl;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setIsRequired(boolean bl) {
        this.isRequired = bl;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String type() {
        return this.type;
    }

    public void setValue(int n, String string) {
        this.values[n] = string;
    }

    public void setValues(String[] stringArray) {
        this.values = stringArray;
    }

    public String[] values() {
        return this.values;
    }

    public String name() {
        return this.name;
    }

    public void convert(DXElement dXElement) throws DTDParseException {
        DXAttribute dXAttribute = new DXAttribute(this.name);
        if (this.type != CDATA) {
            if (this.type == ENUMERATION) {
                dXAttribute.type(DXAttribute.Type.ENUM);
                int n = 0;
                while (n < this.values.length) {
                    if (dXAttribute.enumValues() == null) {
                        dXAttribute.emptyEnumValues();
                    }
                    dXAttribute.enumValues().add(this.values[n]);
                    ++n;
                }
            } else {
                if (this.type == ENTITY || this.type == ENTITIES || this.type == NOTATION) {
                    throw new DTDParseException("Attribute type not supported: " + this.type);
                }
                dXAttribute.type(DXAttribute.Type.parse(this.type.toLowerCase()));
            }
        }
        if (this.defaultValue != null) {
            if (this.isFixed) {
                dXAttribute._default(DXAttribute.Default.FIXED);
            }
            dXAttribute.defaultValue(this.defaultValue);
        } else if (this.isRequired) {
            dXAttribute._default(DXAttribute.Default.REQUIRED);
        } else {
            dXAttribute._default(DXAttribute.Default.IMPLIED);
        }
        if (dXElement.attributes1() == null) {
            dXElement.emptyAttributes1();
        }
        dXElement.attributes1().add(dXAttribute);
    }
}

