/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.gen;

import com.sun.tools.xjc.gen.Declaration;
import com.sun.tools.xjc.gen.Generable;
import com.sun.tools.xjc.gen.Statement;
import com.sun.tools.xjc.gen.Var;
import java.io.PrintWriter;

public class Formatter {
    private int indentLevel;
    private String indentSpace;
    private PrintWriter pw;
    private char lastChar = '\u0000';
    private boolean atBeginningOfLine = true;

    public Formatter(PrintWriter printWriter, String string) {
        this.pw = printWriter;
        this.indentSpace = string;
    }

    public Formatter(PrintWriter printWriter) {
        this(printWriter, "    ");
    }

    public void close() {
        this.pw.close();
    }

    public Formatter o() {
        --this.indentLevel;
        return this;
    }

    public Formatter i() {
        ++this.indentLevel;
        return this;
    }

    private boolean needSpace(char c, char c2) {
        if (c == ']' && c2 == '{') {
            return true;
        }
        if (c == ';') {
            return true;
        }
        if (c == ')' && c2 == '{') {
            return true;
        }
        if (c == ',' || c == '=') {
            return true;
        }
        if (c2 == '=') {
            return true;
        }
        if (Character.isDigit(c)) {
            return c2 != '(' && c2 != ')' && c2 != ';' && c2 != ',';
        }
        if (Character.isJavaIdentifierPart(c)) {
            switch (c2) {
                case '+': 
                case '>': 
                case '{': 
                case '}': {
                    return true;
                }
            }
            return Character.isJavaIdentifierStart(c2);
        }
        if (Character.isJavaIdentifierStart(c2)) {
            switch (c) {
                case ')': 
                case '+': 
                case ']': 
                case '}': {
                    return true;
                }
            }
            return false;
        }
        if (Character.isDigit(c2)) {
            return c != '(';
        }
        return false;
    }

    private void spaceIfNeeded(char c) {
        if (this.atBeginningOfLine) {
            int n = 0;
            while (n < this.indentLevel) {
                this.pw.print(this.indentSpace);
                ++n;
            }
            this.atBeginningOfLine = false;
        } else if (this.lastChar != '\u0000' && this.needSpace(this.lastChar, c)) {
            this.pw.print(' ');
        }
    }

    public Formatter p(char c) {
        this.spaceIfNeeded(c);
        this.pw.print(c);
        this.lastChar = c;
        return this;
    }

    public Formatter p(String string) {
        this.spaceIfNeeded(string.charAt(0));
        this.pw.print(string);
        this.lastChar = string.charAt(string.length() - 1);
        return this;
    }

    public Formatter nl() {
        this.pw.println();
        this.lastChar = '\u0000';
        this.atBeginningOfLine = true;
        return this;
    }

    public Formatter g(Generable generable) {
        generable.generate(this);
        return this;
    }

    public Formatter d(Declaration declaration) {
        declaration.declare(this);
        return this;
    }

    public Formatter s(Statement statement) {
        statement.state(this);
        return this;
    }

    public Formatter b(Var var) {
        var.bind(this);
        return this;
    }
}

