/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.CycleException;
import javax.xml.bind.DuplicateIdentifierException;
import javax.xml.bind.IdentifiableElement;
import javax.xml.bind.MissingIdentifierException;
import javax.xml.bind.StructureValidationException;
import javax.xml.bind.TypeConstraintException;
import javax.xml.bind.UndefinedIdentifierException;
import javax.xml.bind.ValidatableObject;

public final class Validator {
    static Object INITIAL_COLOR = new Color();
    private Object color = new Color();
    private HashMap ids = new HashMap();
    private static int pending = 0;

    Validator() {
    }

    Object color() {
        return this.color;
    }

    private void ensureNotFinished() {
        if (this.color == null) {
            throw new IllegalStateException("Validator previously used");
        }
    }

    private void reference0(String string, Patcher patcher) {
        this.ensureNotFinished();
        if (string == null) {
            throw new IllegalArgumentException("Null identifier");
        }
        Entry entry = (Entry)this.ids.get(string);
        if (entry == null) {
            this.ids.put(string, new Entry(null, patcher));
            return;
        }
        if (patcher == null) {
            return;
        }
        if (entry.target == null) {
            patcher.next = entry.patchers;
            entry.patchers = patcher;
        } else {
            patcher.patch(entry.target);
        }
    }

    public void reference(IdentifiableElement identifiableElement) throws MissingIdentifierException {
        this.ensureNotFinished();
        String string = identifiableElement.id();
        if (string == null) {
            throw new MissingIdentifierException();
        }
        this.reference0(string, null);
    }

    public void reference(String string, Patcher patcher) {
        if (patcher == null) {
            throw new IllegalArgumentException("Null patcher");
        }
        this.reference0(string, patcher);
    }

    void define(String string, IdentifiableElement identifiableElement) throws DuplicateIdentifierException {
        if (string == null || identifiableElement == null) {
            throw new IllegalArgumentException();
        }
        this.ensureNotFinished();
        Entry entry = (Entry)this.ids.get(string);
        if (entry == null) {
            this.ids.put(string, new Entry(identifiableElement, null));
            return;
        }
        if (entry.target == null) {
            entry.target = identifiableElement;
            --pending;
            Patcher patcher = entry.patchers;
            while (patcher != null) {
                patcher.patch(identifiableElement);
                patcher = patcher.next;
            }
            entry.patchers = null;
            return;
        }
        throw new DuplicateIdentifierException(string);
    }

    void finish() throws StructureValidationException {
        this.ensureNotFinished();
        this.color = null;
        if (pending == 0) {
            return;
        }
        Set set = this.ids.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Entry entry2 = (Entry)entry.getValue();
            if (entry2.target != null) continue;
            throw new UndefinedIdentifierException((String)entry.getKey());
        }
        throw new InternalError();
    }

    public void validate(ValidatableObject validatableObject) throws StructureValidationException {
        IdentifiableElement identifiableElement;
        String string;
        if (validatableObject.color() == this.color) {
            throw new CycleException();
        }
        if (validatableObject instanceof IdentifiableElement && (string = (identifiableElement = (IdentifiableElement)((Object)validatableObject)).id()) != null) {
            this.define(string, identifiableElement);
        }
        if (validatableObject.needsValidation()) {
            try {
                validatableObject.validateThis();
            }
            catch (TypeConstraintException typeConstraintException) {
                throw new Error(typeConstraintException.toString());
            }
        }
        validatableObject.color(this.color);
        validatableObject.validate(this);
    }

    void validateRoot(ValidatableObject validatableObject) throws StructureValidationException {
        this.validate(validatableObject);
        this.finish();
    }

    private class Entry {
        private IdentifiableElement target;
        private Patcher patchers = null;

        private Entry(IdentifiableElement identifiableElement, Patcher patcher) {
            this.target = identifiableElement;
            this.patchers = patcher;
            if (identifiableElement == null) {
                pending++;
            }
        }
    }

    public static abstract class Patcher {
        private Patcher next = null;

        public abstract void patch(IdentifiableElement var1);
    }

    private static class Color {
        private Color() {
        }
    }
}

