/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.websocket.DecodeException;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerBase;

public abstract class PojoMessageHandlerWholeBase<T>
extends PojoMessageHandlerBase<T>
implements MessageHandler.Whole<T> {
    public PojoMessageHandlerWholeBase(Object pojo, Method method, Session session, Object[] params, int indexPayload, boolean convert, int indexSession, long maxMessageSize) {
        super(pojo, method, session, params, indexPayload, convert, indexSession, maxMessageSize);
    }

    public final void onMessage(T message) {
        Object payload;
        if (this.params.length == 1 && this.params[0] instanceof DecodeException) {
            ((WsSession)this.session).getLocal().onError(this.session, (Throwable)((DecodeException)((Object)this.params[0])));
            return;
        }
        try {
            payload = this.decode(message);
        }
        catch (DecodeException de) {
            ((WsSession)this.session).getLocal().onError(this.session, (Throwable)de);
            return;
        }
        if (payload == null) {
            payload = this.convert ? this.convert(message) : message;
        }
        Object[] parameters = (Object[])this.params.clone();
        if (this.indexSession != -1) {
            parameters[this.indexSession] = this.session;
        }
        parameters[this.indexPayload] = payload;
        Object result = null;
        try {
            result = this.method.invoke(this.pojo, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.handlePojoMethodException(e);
        }
        this.processResult(result);
    }

    protected Object convert(T message) {
        return message;
    }

    protected abstract Object decode(T var1) throws DecodeException;

    protected abstract void onClose();
}

