/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.gen;

import com.sun.tools.xjc.gen.Expression;
import com.sun.tools.xjc.gen.Formatter;
import com.sun.tools.xjc.gen.Generable;
import com.sun.tools.xjc.gen.Type;

public abstract class Op {
    private Op() {
    }

    static boolean hasTopOp(Expression expression) {
        return expression instanceof UnaryOp || expression instanceof BinaryOp;
    }

    public static Expression minus(Expression expression) {
        return new UnaryOp("-", expression);
    }

    public static Expression not(Expression expression) {
        return new UnaryOp("!", expression);
    }

    public static Expression complement(Expression expression) {
        return new UnaryOp("~", expression);
    }

    public static Expression incr(Expression expression) {
        return new TightUnaryOp(expression, "++");
    }

    public static Expression decr(Expression expression) {
        return new TightUnaryOp(expression, "--");
    }

    public static Expression plus(Expression expression, Expression expression2) {
        return new BinaryOp("+", expression, expression2);
    }

    public static Expression minus(Expression expression, Expression expression2) {
        return new BinaryOp("-", expression, expression2);
    }

    public static Expression mul(Expression expression, Expression expression2) {
        return new BinaryOp("*", expression, expression2);
    }

    public static Expression div(Expression expression, Expression expression2) {
        return new BinaryOp("/", expression, expression2);
    }

    public static Expression mod(Expression expression, Expression expression2) {
        return new BinaryOp("%", expression, expression2);
    }

    public static Expression shl(Expression expression, Expression expression2) {
        return new BinaryOp("<<", expression, expression2);
    }

    public static Expression shr(Expression expression, Expression expression2) {
        return new BinaryOp(">>", expression, expression2);
    }

    public static Expression shrz(Expression expression, Expression expression2) {
        return new BinaryOp(">>>", expression, expression2);
    }

    public static Expression and(Expression expression, Expression expression2) {
        return new BinaryOp("&", expression, expression2);
    }

    public static Expression or(Expression expression, Expression expression2) {
        return new BinaryOp("|", expression, expression2);
    }

    public static Expression cand(Expression expression, Expression expression2) {
        return new BinaryOp("&&", expression, expression2);
    }

    public static Expression cor(Expression expression, Expression expression2) {
        return new BinaryOp("||", expression, expression2);
    }

    public static Expression xor(Expression expression, Expression expression2) {
        return new BinaryOp("^", expression, expression2);
    }

    public static Expression lt(Expression expression, Expression expression2) {
        return new BinaryOp("<", expression, expression2);
    }

    public static Expression lte(Expression expression, Expression expression2) {
        return new BinaryOp("<=", expression, expression2);
    }

    public static Expression gt(Expression expression, Expression expression2) {
        return new BinaryOp(">", expression, expression2);
    }

    public static Expression gte(Expression expression, Expression expression2) {
        return new BinaryOp(">=", expression, expression2);
    }

    public static Expression eq(Expression expression, Expression expression2) {
        return new BinaryOp("==", expression, expression2);
    }

    public static Expression ne(Expression expression, Expression expression2) {
        return new BinaryOp("!=", expression, expression2);
    }

    public static Expression _instanceof(Expression expression, Type type) {
        return new BinaryOp("instanceof", expression, type);
    }

    public static Expression cond(Expression expression, Expression expression2, Expression expression3) {
        return new TernaryOp("?", ":", expression, expression2, expression3);
    }

    private static class TernaryOp
    implements Expression {
        String op1;
        String op2;
        Expression e1;
        Expression e2;
        Expression e3;

        TernaryOp(String string, String string2, Expression expression, Expression expression2, Expression expression3) {
            this.e1 = expression;
            this.op1 = string;
            this.e2 = expression2;
            this.op2 = string2;
            this.e3 = expression3;
        }

        public void generate(Formatter formatter) {
            formatter.p('(').g(this.e1).p(this.op1).g(this.e2).p(this.op2).g(this.e3).p(')');
        }
    }

    private static class BinaryOp
    implements Expression {
        String op;
        Expression left;
        Generable right;

        BinaryOp(String string, Expression expression, Generable generable) {
            this.left = expression;
            this.op = string;
            this.right = generable;
        }

        public void generate(Formatter formatter) {
            formatter.p('(').g(this.left).p(this.op).g(this.right).p(')');
        }
    }

    private static class TightUnaryOp
    extends UnaryOp {
        TightUnaryOp(Expression expression, String string) {
            super(expression, string);
        }

        public void generate(Formatter formatter) {
            if (this.opFirst) {
                formatter.p(this.op).g(this.e);
            } else {
                formatter.g(this.e).p(this.op);
            }
        }
    }

    private static class UnaryOp
    implements Expression {
        protected String op;
        protected Expression e;
        protected boolean opFirst = true;

        UnaryOp(String string, Expression expression) {
            this.op = string;
            this.e = expression;
        }

        UnaryOp(Expression expression, String string) {
            this.op = string;
            this.e = expression;
            this.opFirst = false;
        }

        public void generate(Formatter formatter) {
            if (this.opFirst) {
                formatter.p('(').p(this.op).g(this.e).p(')');
            } else {
                formatter.p('(').g(this.e).p(this.op).p(')');
            }
        }
    }
}

