/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.gen;

import com.sun.tools.xjc.gen.Formatter;
import com.sun.tools.xjc.gen.Generable;
import com.sun.tools.xjc.gen.TypeAtom;

public abstract class Type
implements Generable {
    public static final Type VOID = new TypeAtom("void");
    public static final Type BOOLEAN = new TypeAtom("boolean");
    public static final Type BYTE = new TypeAtom("byte");
    public static final Type SHORT = new TypeAtom("short");
    public static final Type CHAR = new TypeAtom("char");
    public static final Type INT = new TypeAtom("int");
    public static final Type FLOAT = new TypeAtom("float");
    public static final Type LONG = new TypeAtom("long");
    public static final Type DOUBLE = new TypeAtom("double");

    public static Type parse(String string) {
        if (string.equals("void")) {
            return VOID;
        }
        if (string.equals("boolean")) {
            return BOOLEAN;
        }
        if (string.equals("byte")) {
            return BYTE;
        }
        if (string.equals("short")) {
            return SHORT;
        }
        if (string.equals("char")) {
            return CHAR;
        }
        if (string.equals("int")) {
            return INT;
        }
        if (string.equals("float")) {
            return FLOAT;
        }
        if (string.equals("long")) {
            return LONG;
        }
        if (string.equals("double")) {
            return DOUBLE;
        }
        throw new IllegalArgumentException("Not a primitive type: " + string);
    }

    public Type array() {
        return new ArrayType(this);
    }

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public Type elementType() {
        throw new IllegalArgumentException("Not an array type");
    }

    public abstract void generate(Formatter var1);

    private static class ArrayType
    extends Type {
        private Type elementType;

        private ArrayType(Type type) {
            this.elementType = type;
        }

        public boolean isArray() {
            return true;
        }

        public Type elementType() {
            return this.elementType;
        }

        public void generate(Formatter formatter) {
            this.elementType.generate(formatter);
            formatter.p("[]");
        }

        public String toString() {
            return this.getClass().getName() + "(" + this.elementType.toString() + "[]" + ")";
        }
    }
}

