/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLChoiceCollectionMappingUnmarshalNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCollectionReferenceMappingMarshalNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCollectionReferenceMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeDirectCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.ChoiceCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.CollectionReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.CompositeCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.DirectCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;

public class XMLChoiceCollectionMappingMarshalNodeValue
extends MappingNodeValue
implements ContainerValue {
    private ChoiceCollectionMapping xmlChoiceCollectionMapping;
    private Map<Field, NodeValue> fieldToNodeValues;
    private Map<Class, NodeValue> classToNodeValues;
    private NodeValue choiceElementNodeValue;
    private Field xmlField;
    private boolean isMixedNodeValue;
    private boolean isAny;
    private NodeValue anyNodeValue;
    private int index = -1;

    public XMLChoiceCollectionMappingMarshalNodeValue(ChoiceCollectionMapping mapping, Field xmlField) {
        this.xmlChoiceCollectionMapping = mapping;
        this.xmlField = xmlField;
        this.isAny = mapping.isAny();
        this.initializeNodeValue();
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        if (this.isMixedNodeValue) {
            return xPathFragment.nameIsText();
        }
        return this.choiceElementNodeValue.isOwningNode(xPathFragment);
    }

    public void setFieldToNodeValues(Map<Field, NodeValue> fieldToNodeValues) {
        this.fieldToNodeValues = fieldToNodeValues;
        this.classToNodeValues = new HashMap<Class, NodeValue>();
        for (Field nextField : fieldToNodeValues.keySet()) {
            Class associatedClass = this.xmlChoiceCollectionMapping.getFieldToClassMappings().get(nextField);
            this.classToNodeValues.put(associatedClass, fieldToNodeValues.get(nextField));
        }
        Set<Class> classes = this.classToNodeValues.keySet();
        for (Class nextClass : this.xmlChoiceCollectionMapping.getChoiceElementMappingsByClass().keySet()) {
            if (classes.contains(nextClass)) continue;
            Field field = (Field)this.xmlChoiceCollectionMapping.getClassToFieldMappings().get(nextClass);
            XMLChoiceCollectionMappingUnmarshalNodeValue nodeValue = new XMLChoiceCollectionMappingUnmarshalNodeValue(this.xmlChoiceCollectionMapping, this.xmlField, (Mapping)this.xmlChoiceCollectionMapping.getChoiceElementMappingsByClass().get(nextClass));
            this.classToNodeValues.put(nextClass, nodeValue);
            NodeValue nodeValueForField = fieldToNodeValues.get(field);
            ((NodeValue)nodeValue).setXPathNode(nodeValueForField.getXPathNode());
        }
    }

    private void initializeNodeValue() {
        CollectionReferenceMapping refMapping;
        Mapping xmlMapping = (Mapping)this.xmlChoiceCollectionMapping.getChoiceElementMappings().get(this.xmlField);
        this.choiceElementNodeValue = xmlMapping instanceof BinaryDataCollectionMapping ? new XMLBinaryDataCollectionMappingNodeValue((BinaryDataCollectionMapping)xmlMapping) : (xmlMapping instanceof DirectCollectionMapping ? new XMLCompositeDirectCollectionMappingNodeValue((DirectCollectionMapping)xmlMapping) : (xmlMapping instanceof CompositeCollectionMapping ? new XMLCompositeCollectionMappingNodeValue((CompositeCollectionMapping)xmlMapping) : ((refMapping = (CollectionReferenceMapping)xmlMapping).usesSingleNode() || refMapping.getFields().size() == 1 ? new XMLCollectionReferenceMappingNodeValue(refMapping, this.xmlField) : new XMLCollectionReferenceMappingMarshalNodeValue((CollectionReferenceMapping)xmlMapping))));
        if (this.isAny) {
            this.anyNodeValue = new XMLChoiceCollectionMappingUnmarshalNodeValue(this.xmlChoiceCollectionMapping, null, this.xmlChoiceCollectionMapping.getAnyMapping());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        block18: {
            if (this.xmlChoiceCollectionMapping.isReadOnly()) {
                return false;
            }
            value = this.xmlChoiceCollectionMapping.getAttributeValueFromObject(object);
            if (value == null) {
                wrapperNP = this.xmlChoiceCollectionMapping.getWrapperNullPolicy();
                if (wrapperNP != null && wrapperNP.getMarshalNullRepresentation() == XMLNullRepresentationType.XSI_NIL) {
                    marshalRecord.nilSimple(namespaceResolver);
                    return true;
                }
                return false;
            }
            cp = this.getContainerPolicy();
            iterator = cp.iteratorFor(value);
            if (iterator != null && cp.hasNext(iterator)) {
                if (xPathFragment != null) {
                    groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
                    marshalRecord.closeStartGroupingElements(groupingFragment);
                }
            } else {
                return marshalRecord.emptyCollection(xPathFragment, namespaceResolver, this.xmlChoiceCollectionMapping.getWrapperNullPolicy() != null);
            }
            if (!marshalRecord.getMarshaller().getMediaType().isApplicationJSON()) ** GOTO lbl80
            nodeValues = new ArrayList<NodeValue>();
            values = new ArrayList<ArrayList<E>>();
            mixedNodeValue = null;
            mixedValues = null;
            while (cp.hasNext(iterator)) {
                nextValue = this.xmlChoiceCollectionMapping.convertObjectValueToDataValue(cp.next(iterator, session), session, marshalRecord.getMarshaller());
                nodeValue = this.getNodeValueForValue(nextValue);
                if (nodeValue == null) continue;
                if (nodeValue == this) {
                    mixedNodeValue = this;
                    if (mixedValues == null) {
                        mixedValues = new ArrayList<Object>();
                    }
                    mixedValues.add(nextValue);
                    continue;
                }
                index = nodeValues.indexOf(nodeValue);
                if (index > -1) {
                    ((List)values.get(index)).add(nextValue);
                    continue;
                }
                nodeValues.add(nodeValue);
                valuesList = new ArrayList<Object>();
                valuesList.add(nextValue);
                values.add(valuesList);
            }
            if (mixedNodeValue != null) {
                nodeValues.add(mixedNodeValue);
                values.add(mixedValues);
            }
            i = 0;
            while (i < nodeValues.size()) {
                associatedNodeValue = (NodeValue)nodeValues.get(i);
                listValue = (List)values.get(i);
                frag = null;
                if (associatedNodeValue == this) {
                    frag = marshalRecord.getTextWrapperFragment();
                } else {
                    frag = associatedNodeValue.getXPathNode().getXPathFragment();
                    if (frag != null) {
                        frag = this.getOwningFragment(associatedNodeValue, frag);
                        associatedNodeValue = ((XMLChoiceCollectionMappingUnmarshalNodeValue)associatedNodeValue).getChoiceElementMarshalNodeValue();
                    }
                }
                if (frag != null || associatedNodeValue.isAnyMappingNodeValue()) {
                    valueSize = listValue.size();
                    marshalRecord.startCollection();
                    j = 0;
                    while (j < valueSize) {
                        this.marshalSingleValueWithNodeValue(frag, marshalRecord, object, listValue.get(j), session, namespaceResolver, ObjectMarshalContext.getInstance(), associatedNodeValue);
                        ++j;
                    }
                    marshalRecord.endCollection();
                }
                ++i;
            }
            break block18;
lbl-1000:
            // 1 sources

            {
                nextValue = cp.next(iterator, session);
                this.marshalSingleValue(xPathFragment, marshalRecord, object, nextValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
lbl80:
                // 2 sources

                ** while (cp.hasNext((Object)iterator))
            }
        }
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if ((value = this.xmlChoiceCollectionMapping.convertObjectValueToDataValue(value, session, marshalRecord.getMarshaller())) != null && value.getClass() == CoreClassConstants.STRING && this.xmlChoiceCollectionMapping.isMixedContent()) {
            this.marshalMixedContent(marshalRecord, (String)value);
            return true;
        }
        NodeValue associatedNodeValue = this.getNodeValueForValue(value);
        if (associatedNodeValue != null) {
            if (associatedNodeValue.isAnyMappingNodeValue()) {
                return this.marshalSingleValueWithNodeValue(null, marshalRecord, object, value, session, namespaceResolver, marshalContext, associatedNodeValue);
            }
            XPathFragment frag = associatedNodeValue.getXPathNode().getXPathFragment();
            if (frag != null) {
                frag = this.getOwningFragment(associatedNodeValue, frag);
                NodeValue unwrappedNodeValue = ((XMLChoiceCollectionMappingUnmarshalNodeValue)associatedNodeValue).getChoiceElementMarshalNodeValue();
                return this.marshalSingleValueWithNodeValue(frag, marshalRecord, object, value, session, namespaceResolver, marshalContext, unwrappedNodeValue);
            }
        }
        return true;
    }

    private boolean marshalSingleValueWithNodeValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext, NodeValue unwrappedNodeValue) {
        if (unwrappedNodeValue != null) {
            unwrappedNodeValue.marshalSingleValue(xPathFragment, marshalRecord, object, value, session, namespaceResolver, marshalContext);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private NodeValue getNodeValueForValue(Object value) {
        void var3_11;
        if (value == null) {
            for (XMLChoiceCollectionMappingUnmarshalNodeValue xMLChoiceCollectionMappingUnmarshalNodeValue : this.fieldToNodeValues.values()) {
                Mapping nextMapping;
                NodeValue nextNodeValue = xMLChoiceCollectionMappingUnmarshalNodeValue.getChoiceElementMarshalNodeValue();
                if (!(nextNodeValue instanceof MappingNodeValue) || !((nextMapping = ((MappingNodeValue)nextNodeValue).getMapping()).isAbstractCompositeCollectionMapping() ? ((CompositeCollectionMapping)nextMapping).getNullPolicy().isNullRepresentedByXsiNil() : (nextMapping.isAbstractCompositeDirectCollectionMapping() ? ((DirectCollectionMapping)nextMapping).getNullPolicy().isNullRepresentedByXsiNil() : nextMapping instanceof BinaryDataCollectionMapping && ((BinaryDataCollectionMapping)nextMapping).getNullPolicy().isNullRepresentedByXsiNil()))) continue;
                return xMLChoiceCollectionMappingUnmarshalNodeValue;
            }
            return null;
        }
        Field associatedField = null;
        Object var3_5 = null;
        if (value instanceof Root) {
            Root rootValue = (Root)value;
            String localName = rootValue.getLocalName();
            String namespaceUri = rootValue.getNamespaceURI();
            Object fieldValue = rootValue.getObject();
            associatedField = this.getFieldForName(localName, namespaceUri);
            if (associatedField == null) {
                if (this.xmlChoiceCollectionMapping.isAny()) {
                    return this.anyNodeValue;
                }
                Class<?> theClass = fieldValue.getClass();
                while (associatedField == null) {
                    associatedField = (Field)this.xmlChoiceCollectionMapping.getClassToFieldMappings().get(theClass);
                    if (theClass.getSuperclass() == null) break;
                    theClass = theClass.getSuperclass();
                }
            }
            if (associatedField != null) {
                NodeValue nodeValue = this.fieldToNodeValues.get(associatedField);
            }
        } else {
            Class<?> theClass = value.getClass();
            while (associatedField == null) {
                associatedField = (Field)this.xmlChoiceCollectionMapping.getClassToFieldMappings().get(theClass);
                NodeValue nodeValue = this.classToNodeValues.get(theClass);
                if (theClass.getSuperclass() == null) break;
                theClass = theClass.getSuperclass();
            }
        }
        if (associatedField == null) {
            List sourceFields = null;
            Class<?> theClass = value.getClass();
            while (theClass != null) {
                sourceFields = this.xmlChoiceCollectionMapping.getClassToSourceFieldsMappings().get(theClass);
                if (sourceFields != null) break;
                theClass = theClass.getSuperclass();
            }
            if (sourceFields != null) {
                associatedField = (Field)sourceFields.get(0);
                NodeValue nodeValue = this.fieldToNodeValues.get(associatedField);
            }
        }
        if (var3_11 != null) {
            return var3_11;
        }
        if (associatedField != null) {
            return this.fieldToNodeValues.get(associatedField);
        }
        if (this.xmlChoiceCollectionMapping.isMixedContent() && value instanceof String) {
            return this;
        }
        if (this.xmlChoiceCollectionMapping.isAny()) {
            return this.anyNodeValue;
        }
        return null;
    }

    private XPathFragment getOwningFragment(NodeValue nodeValue, XPathFragment frag) {
        while (frag != null) {
            if (nodeValue.isOwningNode(frag)) {
                return frag;
            }
            frag = frag.getNextFragment();
        }
        return null;
    }

    private void marshalMixedContent(MarshalRecord record, String value) {
        record.characters(value);
    }

    private Field getFieldForName(String localName, String namespaceUri) {
        for (Field nextField : this.fieldToNodeValues.keySet()) {
            if (nextField == null) continue;
            XPathFragment fragment = nextField.getXPathFragment();
            while (fragment != null && !fragment.nameIsText()) {
                if ((fragment.getNextFragment() == null || fragment.getHasText()) && fragment.getLocalName().equals(localName)) {
                    String fragUri = fragment.getNamespaceURI();
                    if (namespaceUri == null && fragUri == null || namespaceUri != null && fragUri != null && namespaceUri.equals(fragUri)) {
                        return nextField;
                    }
                }
                fragment = fragment.getNextFragment();
            }
        }
        return null;
    }

    public Collection<NodeValue> getAllNodeValues() {
        return this.fieldToNodeValues.values();
    }

    @Override
    public boolean isMarshalNodeValue() {
        return true;
    }

    @Override
    public boolean isUnmarshalNodeValue() {
        return false;
    }

    @Override
    public boolean isWrapperAllowedAsCollectionName() {
        return false;
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlChoiceCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public CoreContainerPolicy getContainerPolicy() {
        return this.xmlChoiceCollectionMapping.getContainerPolicy();
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public ChoiceCollectionMapping getMapping() {
        return this.xmlChoiceCollectionMapping;
    }

    @Override
    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }

    public void setIsMixedNodeValue(boolean b) {
        this.isMixedNodeValue = b;
    }

    @Override
    public boolean isMixedContentNodeValue() {
        return this.isMixedNodeValue;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }

    @Override
    public void setXPathNode(XPathNode xPathNode) {
        super.setXPathNode(xPathNode);
        if (this.anyNodeValue != null) {
            this.anyNodeValue.setXPathNode(xPathNode);
        }
    }
}

