/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.gen;

import com.sun.tools.xjc.gen.Array;
import com.sun.tools.xjc.gen.ArrayCompRef;
import com.sun.tools.xjc.gen.Assignment;
import com.sun.tools.xjc.gen.AssignmentTarget;
import com.sun.tools.xjc.gen.Atom;
import com.sun.tools.xjc.gen.Cast;
import com.sun.tools.xjc.gen.Class;
import com.sun.tools.xjc.gen.Expression;
import com.sun.tools.xjc.gen.FieldRef;
import com.sun.tools.xjc.gen.Formatter;
import com.sun.tools.xjc.gen.Invocation;
import com.sun.tools.xjc.gen.Method;
import com.sun.tools.xjc.gen.Type;
import com.sun.tools.xjc.gen.Var;

public abstract class Expr {
    private Expr() {
    }

    public static Expression assign(AssignmentTarget assignmentTarget, Expression expression) {
        return new Assignment(assignmentTarget, expression);
    }

    public static Expression assignPlus(AssignmentTarget assignmentTarget, Expression expression) {
        return new Assignment(assignmentTarget, expression, "+");
    }

    public static Invocation _new(Class clazz) {
        return new Invocation(clazz);
    }

    public static Invocation _new(Type type) {
        return new Invocation(type);
    }

    public static Invocation invoke(String string) {
        return new Invocation(null, string);
    }

    public static Invocation invoke(Expression expression, Method method) {
        return new Invocation(expression, method.name());
    }

    public static Invocation invoke(Expression expression, String string) {
        return new Invocation(expression, string);
    }

    public static FieldRef ref(String string) {
        return new FieldRef(null, string);
    }

    public static FieldRef ref(Expression expression, Var var) {
        return new FieldRef(expression, var.name());
    }

    public static FieldRef ref(Expression expression, String string) {
        return new FieldRef(expression, string);
    }

    public static FieldRef refthis(String string) {
        return new FieldRef(null, string, true);
    }

    public static Expression dotclass(final Class clazz) {
        return new Expression(){

            public void generate(Formatter formatter) {
                formatter.p('(').g(clazz).p(".class)");
            }
        };
    }

    public static Expression dotclass(final Type type) {
        return new Expression(){

            public void generate(Formatter formatter) {
                formatter.p('(').g(type).p(".class)");
            }
        };
    }

    public static ArrayCompRef component(Expression expression, Expression expression2) {
        return new ArrayCompRef(expression, expression2);
    }

    public static Cast cast(Type type, Expression expression) {
        return new Cast(type, expression);
    }

    public static Array newArray(Type type) {
        return new Array(type, null);
    }

    public static Array newArray(Type type, Expression expression) {
        return new Array(type, expression);
    }

    public static Expression _null() {
        return new Atom("null");
    }

    public static Expression lit(boolean bl) {
        return new Atom(bl ? "true" : "false");
    }

    public static Expression lit(int n) {
        return new Atom(Integer.toString(n));
    }

    public static Expression lit(long l) {
        return new Atom(Long.toString(l) + "L");
    }

    public static Expression lit(float f) {
        return new Atom(Float.toString(f) + "F");
    }

    public static Expression lit(double d) {
        return new Atom(Double.toString(d) + "D");
    }

    private static String quotify(char c, String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 2);
        stringBuffer.append(c);
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (c2 == '\\' || c2 == '\"' || c2 == '\'') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c2);
            ++n2;
        }
        stringBuffer.append(c);
        return stringBuffer.toString();
    }

    public static Expression lit(char c) {
        return new Atom(Expr.quotify('\'', "" + c));
    }

    public static Expression lit(String string) {
        return new Atom(Expr.quotify('\"', string));
    }
}

