/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.jersey.server.internal.monitoring.ExecutionStatisticsImpl;
import org.glassfish.jersey.server.internal.monitoring.MonitoringUtils;
import org.glassfish.jersey.server.internal.monitoring.ResourceMethodStatisticsImpl;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ExecutionStatistics;
import org.glassfish.jersey.server.monitoring.ResourceMethodStatistics;
import org.glassfish.jersey.server.monitoring.ResourceStatistics;

class ResourceStatisticsImpl
implements ResourceStatistics {
    private final Map<ResourceMethod, ResourceMethodStatistics> resourceMethods;
    private final ExecutionStatistics resourceExecutionStatistics;
    private final ExecutionStatistics requestExecutionStatistics;

    private ResourceStatisticsImpl(Map<ResourceMethod, ResourceMethodStatistics> resourceMethods, ExecutionStatistics resourceExecutionStatistics, ExecutionStatistics requestExecutionStatistics) {
        this.resourceMethods = resourceMethods;
        this.resourceExecutionStatistics = resourceExecutionStatistics;
        this.requestExecutionStatistics = requestExecutionStatistics;
    }

    @Override
    public ExecutionStatistics getResourceMethodExecutionStatistics() {
        return this.resourceExecutionStatistics;
    }

    @Override
    public ExecutionStatistics getRequestExecutionStatistics() {
        return this.requestExecutionStatistics;
    }

    @Override
    public Map<ResourceMethod, ResourceMethodStatistics> getResourceMethodStatistics() {
        return this.resourceMethods;
    }

    @Override
    public ResourceStatistics snapshot() {
        return this;
    }

    static class Builder {
        private final ExecutionStatisticsImpl.Builder resourceExecutionStatisticsBuilder;
        private final ExecutionStatisticsImpl.Builder requestExecutionStatisticsBuilder;
        private final Map<ResourceMethod, ResourceMethodStatisticsImpl.Builder> methodsBuilders = Maps.newHashMap();
        private final Map<String, ResourceMethodStatisticsImpl.Builder> stringToMethodsBuilders = Maps.newHashMap();

        Builder(Resource resource) {
            this();
            for (ResourceMethod method : resource.getResourceMethods()) {
                this.getOrCreate(method);
            }
        }

        Builder() {
            this.resourceExecutionStatisticsBuilder = new ExecutionStatisticsImpl.Builder();
            this.requestExecutionStatisticsBuilder = new ExecutionStatisticsImpl.Builder();
        }

        ResourceStatisticsImpl build() {
            HashMap resourceMethods = Maps.newHashMap();
            for (Map.Entry<ResourceMethod, ResourceMethodStatisticsImpl.Builder> methodEntry : this.methodsBuilders.entrySet()) {
                resourceMethods.put(methodEntry.getKey(), methodEntry.getValue().build());
            }
            return new ResourceStatisticsImpl(Collections.unmodifiableMap(resourceMethods), this.resourceExecutionStatisticsBuilder.build(), this.requestExecutionStatisticsBuilder.build());
        }

        void addExecution(ResourceMethod resourceMethod, long methodStartTime, long methodDuration, long requestStartTime, long requestDuration) {
            this.resourceExecutionStatisticsBuilder.addExecution(methodStartTime, methodDuration);
            this.requestExecutionStatisticsBuilder.addExecution(requestStartTime, requestDuration);
            ResourceMethodStatisticsImpl.Builder builder = this.getOrCreate(resourceMethod);
            builder.addResourceMethodExecution(methodStartTime, methodDuration, requestStartTime, requestDuration);
        }

        void addMethod(ResourceMethod resourceMethod) {
            this.getOrCreate(resourceMethod);
        }

        private ResourceMethodStatisticsImpl.Builder getOrCreate(ResourceMethod resourceMethod) {
            String methodUniqueId = MonitoringUtils.getMethodUniqueId(resourceMethod);
            ResourceMethodStatisticsImpl.Builder methodBuilder = this.stringToMethodsBuilders.get(methodUniqueId);
            if (methodBuilder == null) {
                methodBuilder = new ResourceMethodStatisticsImpl.Builder(resourceMethod);
                this.methodsBuilders.put(resourceMethod, methodBuilder);
                this.stringToMethodsBuilders.put(methodUniqueId, methodBuilder);
            }
            return methodBuilder;
        }
    }
}

