/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.gen;

import com.sun.tools.xjc.gen.Formatter;
import com.sun.tools.xjc.gen.Generable;
import java.io.PrintWriter;
import java.io.StringWriter;

class Mods
implements Generable {
    private static int VAR = 8;
    private static int FIELD = 799;
    private static int METHOD = 255;
    private static int CLASS = 31;
    private static int INTERFACE = 1;
    private int mods;

    private Mods(int n) {
        this.mods = n;
    }

    private static void check(int n, int n2, String string) {
        if ((n & ~n2) != 0) {
            throw new IllegalArgumentException("Illegal modifiers for " + string + ": " + new Mods(n).toString());
        }
    }

    static Mods forVar(int n) {
        Mods.check(n, VAR, "variable");
        return new Mods(n);
    }

    static Mods forField(int n) {
        Mods.check(n, FIELD, "field");
        return new Mods(n);
    }

    static Mods forMethod(int n) {
        Mods.check(n, METHOD, "method");
        return new Mods(n);
    }

    static Mods forClass(int n) {
        Mods.check(n, CLASS, "class");
        return new Mods(n);
    }

    static Mods forInterface(int n) {
        Mods.check(n, INTERFACE, "class");
        return new Mods(n);
    }

    boolean isAbstract() {
        return (this.mods & 0x20) != 0;
    }

    boolean isNative() {
        return (this.mods & 0x40) != 0;
    }

    public void generate(Formatter formatter) {
        if ((this.mods & 1) != 0) {
            formatter.p("public");
        }
        if ((this.mods & 2) != 0) {
            formatter.p("protected");
        }
        if ((this.mods & 4) != 0) {
            formatter.p("private");
        }
        if ((this.mods & 8) != 0) {
            formatter.p("final");
        }
        if ((this.mods & 0x10) != 0) {
            formatter.p("static");
        }
        if ((this.mods & 0x20) != 0) {
            formatter.p("abstract");
        }
        if ((this.mods & 0x40) != 0) {
            formatter.p("native");
        }
        if ((this.mods & 0x80) != 0) {
            formatter.p("synchronized");
        }
        if ((this.mods & 0x100) != 0) {
            formatter.p("transient");
        }
        if ((this.mods & 0x200) != 0) {
            formatter.p("volatile");
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        Formatter formatter = new Formatter(new PrintWriter(stringWriter));
        this.generate(formatter);
        return stringWriter.toString();
    }
}

