/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.xml.bind.MarshallableObject;
import javax.xml.bind.NullValueException;

public final class PredicatedLists {
    private PredicatedLists() {
    }

    public static List create(MarshallableObject marshallableObject, Predicate predicate, List list) {
        return new PredicatedList(list, marshallableObject, predicate, false);
    }

    public static List createInvalidating(MarshallableObject marshallableObject, Predicate predicate, List list) {
        return new PredicatedList(list, marshallableObject, predicate, true);
    }

    private static class PredicatedList
    extends PredicatedCollection
    implements List {
        private final List list;

        private PredicatedList(List list, MarshallableObject marshallableObject, Predicate predicate, boolean bl) {
            super(list, marshallableObject, predicate, bl);
            this.list = list;
        }

        public Object get(int n) {
            return this.list.get(n);
        }

        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        public List subList(int n, int n2) {
            return this.list.subList(n, n2);
        }

        public Object remove(int n) {
            Object e = this.list.remove(n);
            this.invalidate();
            return e;
        }

        public void add(int n, Object object) {
            this.pred.check(object);
            this.list.add(n, object);
            this.invalidate();
        }

        public boolean addAll(int n, Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.pred.check(iterator.next());
            }
            return this.invalidateIfChanged(this.list.addAll(n, collection));
        }

        public Object set(int n, Object object) {
            this.pred.check(object);
            Object object2 = this.list.set(n, object);
            this.invalidate();
            return object2;
        }

        public ListIterator listIterator(int n) {
            final ListIterator listIterator = this.list.listIterator(n);
            return new ListIterator(){

                public boolean hasNext() {
                    return listIterator.hasNext();
                }

                public boolean hasPrevious() {
                    return listIterator.hasPrevious();
                }

                public Object next() {
                    return listIterator.next();
                }

                public int nextIndex() {
                    return listIterator.nextIndex();
                }

                public Object previous() {
                    return listIterator.previous();
                }

                public int previousIndex() {
                    return listIterator.previousIndex();
                }

                public void remove() {
                    this.invalidate();
                    listIterator.remove();
                }

                public void add(Object object) {
                    pred.check(object);
                    this.invalidate();
                    listIterator.add(object);
                }

                public void set(Object object) {
                    pred.check(object);
                    this.invalidate();
                    listIterator.set(object);
                }
            };
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }
    }

    static class PredicatedCollection
    implements Collection,
    Set {
        protected MarshallableObject mob;
        protected final Collection col;
        protected final Predicate pred;
        private final boolean invalidate;

        protected final void invalidate() {
            if (this.invalidate && this.mob != null) {
                this.mob.invalidate();
            }
        }

        protected final boolean invalidateIfChanged(boolean bl) {
            if (bl) {
                this.invalidate();
            }
            return bl;
        }

        protected final void check(Object object) {
            if (object == null) {
                throw new NullValueException();
            }
            this.pred.check(object);
        }

        public final void disassociate() {
            this.mob = null;
        }

        private PredicatedCollection(Collection collection, MarshallableObject marshallableObject, Predicate predicate, boolean bl) {
            if (collection == null) {
                throw new IllegalArgumentException();
            }
            this.mob = marshallableObject;
            this.pred = predicate;
            this.col = collection;
            this.invalidate = bl;
        }

        public int size() {
            return this.col.size();
        }

        public boolean isEmpty() {
            return this.col.isEmpty();
        }

        public Iterator iterator() {
            return this.col.iterator();
        }

        public boolean contains(Object object) {
            return this.col.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.col.containsAll(collection);
        }

        public Object[] toArray() {
            return this.col.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.col.toArray(objectArray);
        }

        public String toString() {
            return this.col.toString();
        }

        public boolean equals(Object object) {
            return this.col.equals(object);
        }

        public int hashCode() {
            return this.col.hashCode();
        }

        public boolean remove(Object object) {
            return this.invalidateIfChanged(this.col.remove(object));
        }

        public boolean removeAll(Collection collection) {
            return this.invalidateIfChanged(this.col.removeAll(collection));
        }

        public boolean retainAll(Collection collection) {
            return this.invalidateIfChanged(this.col.retainAll(collection));
        }

        public void clear() {
            if (this.col.size() > 0) {
                this.invalidate();
            }
            this.col.clear();
        }

        public boolean add(Object object) {
            this.pred.check(object);
            return this.invalidateIfChanged(this.col.add(object));
        }

        public boolean addAll(Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.pred.check(iterator.next());
            }
            return this.invalidateIfChanged(this.col.addAll(collection));
        }
    }

    public static interface Predicate {
        public void check(Object var1);
    }
}

