/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.dtd;

import com.sun.tools.xjc.dtd.ContentModel;
import com.sun.tools.xjc.dtd.DTD;
import com.sun.tools.xjc.dtd.DTDParser;
import com.sun.tools.xjc.dtd.Element;
import com.sun.tools.xjc.dtd.ElementModel;
import com.sun.tools.xjc.dtd.Notation;
import com.sun.tools.xjc.dtd.StringModel;
import com.sun.tools.xjc.dtd.parser.DTDHandlerBase;
import com.sun.tools.xjc.dtd.parser.DTDParseException;
import com.sun.tools.xjc.dtd.parser.InputEntity;
import java.util.Iterator;
import java.util.Map;

public class DTDHandler
extends DTDHandlerBase {
    private DTD dtd = new DTD();
    private DTDParser parser;
    private InputEntity current;

    public DTDHandler(DTDParser dTDParser) {
        this.parser = dTDParser;
    }

    public DTD dtd() {
        return this.dtd;
    }

    public void startDTD(InputEntity inputEntity) {
        this.current = inputEntity;
    }

    public void elementDecl(Element element) {
        Element element2;
        if (element.contentModel() != null) {
            if (this.parser.isFlattening()) {
                element.contentModel().flatten();
            }
            if (this.parser.isCanonicalizing()) {
                element.contentModel().canonicalize();
            }
        }
        if ((element2 = this.dtd.getElement(element.name())) == null) {
            this.dtd.addElement(element);
        } else {
            element2.setContentModel(element.contentModel());
        }
    }

    public void notationDecl(String string, String string2, String string3) {
        this.dtd.addNotation(new Notation(string, string2, string3));
    }

    public void endDTD() throws DTDParseException {
        Iterator iterator = this.dtd.elements().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (element.contentModel() == null) continue;
            this.completeModel(element.contentModel());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void completeModel(ContentModel contentModel) throws DTDParseException {
        if (contentModel instanceof ElementModel) {
            ElementModel elementModel = (ElementModel)contentModel;
            String string = elementModel.elementName();
            Map map = this.dtd.elementMap();
            if (!map.containsKey(string)) throw new DTDParseException("Undeclared element: " + elementModel.elementName());
            Element element = (Element)map.get(string);
            if (element.contentModel() == null) return;
            elementModel.addChild(element.contentModel());
            return;
        } else {
            if (contentModel instanceof StringModel) return;
            Iterator iterator = contentModel.children().iterator();
            while (iterator.hasNext()) {
                this.completeModel((ContentModel)iterator.next());
            }
        }
    }
}

