/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.util.Vector;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class EISOrderedCollectionChangeRecord
extends CollectionChangeRecord
implements org.eclipse.persistence.sessions.changesets.EISOrderedCollectionChangeRecord {
    private Vector adds;
    private int[] addIndexes;
    private Vector moves;
    private int[][] moveIndexPairs;
    private Vector removes;
    private int[] removeIndexes;

    public EISOrderedCollectionChangeRecord(ObjectChangeSet owner, String attributeName, DatabaseMapping mapping) {
        this.owner = owner;
        this.attribute = attributeName;
        this.mapping = mapping;
    }

    public void addAddedChangeSet(Object changeSet, int index) {
        this.getAdds().addElement(changeSet);
        this.setAddIndexes(this.addTo(index, this.getAddIndexes()));
    }

    public void addMovedChangeSet(Object changeSet, int oldIndex, int newIndex) {
        this.getMoves().addElement(changeSet);
        int[] pair = new int[]{oldIndex, newIndex};
        this.setMoveIndexPairs(this.addTo(pair, this.getMoveIndexPairs()));
    }

    public void addRemovedChangeSet(Object changeSet, int index) {
        this.getRemoves().addElement(changeSet);
        this.setRemoveIndexes(this.addTo(index, this.getRemoveIndexes()));
    }

    private int[] addTo(int newInt, int[] oldArray) {
        int oldCount = oldArray.length;
        int[] newArray = new int[oldCount + 1];
        System.arraycopy(oldArray, 0, newArray, 0, oldCount);
        newArray[oldCount] = newInt;
        return newArray;
    }

    private int[][] addTo(int[] newInts, int[][] oldArray) {
        int oldCount = oldArray.length;
        int[][] newArray = new int[oldCount + 1][];
        System.arraycopy(oldArray, 0, newArray, 0, oldCount);
        newArray[oldCount] = newInts;
        return newArray;
    }

    private Object getAdd(int index) {
        return this.getAdds().get(index);
    }

    @Override
    public int[] getAddIndexes() {
        if (this.addIndexes == null) {
            this.addIndexes = new int[0];
        }
        return this.addIndexes;
    }

    @Override
    public Vector getAdds() {
        if (this.adds == null) {
            this.adds = new Vector(1);
        }
        return this.adds;
    }

    private int getAddsIndexOf(Object changeSet) {
        if (this.adds == null) {
            return -1;
        }
        return this.adds.indexOf(changeSet);
    }

    private int getAddsSize() {
        if (this.adds == null) {
            return 0;
        }
        return this.adds.size();
    }

    private Object getMove(int index) {
        return this.getMoves().get(index);
    }

    private int getBeforeMoveIndex(int index) {
        int[][] pairs = this.getMoveIndexPairs();
        return pairs[index][0];
    }

    @Override
    public int[][] getMoveIndexPairs() {
        if (this.moveIndexPairs == null) {
            this.moveIndexPairs = new int[0][0];
        }
        return this.moveIndexPairs;
    }

    @Override
    public Vector getMoves() {
        if (this.moves == null) {
            this.moves = new Vector(1);
        }
        return this.moves;
    }

    private int getMovesIndexOf(Object changeSet) {
        if (this.moves == null) {
            return -1;
        }
        return this.moves.indexOf(changeSet);
    }

    private int getMovesSize() {
        if (this.moves == null) {
            return 0;
        }
        return this.moves.size();
    }

    @Override
    public Vector getNewCollection() {
        int[][] localMoveIndexPairs;
        int newSize = this.getNewCollectionSize();
        Vector<Object> newCollection = new Vector<Object>(newSize);
        int[] localAddIndexes = this.addIndexes;
        if (localAddIndexes == null) {
            localAddIndexes = new int[]{};
        }
        if ((localMoveIndexPairs = this.moveIndexPairs) == null) {
            localMoveIndexPairs = new int[0][0];
        }
        int addIndex = 0;
        int moveIndex = 0;
        int i = 0;
        while (i < newSize) {
            if (addIndex < localAddIndexes.length && localAddIndexes[addIndex] == i) {
                newCollection.add(this.getAdd(addIndex));
                ++addIndex;
            } else if (moveIndex < localMoveIndexPairs.length && localMoveIndexPairs[moveIndex][1] == i) {
                newCollection.add(this.getMove(moveIndex));
                ++moveIndex;
            } else {
                throw new IllegalStateException(String.valueOf(i));
            }
            ++i;
        }
        return newCollection;
    }

    private int getNewCollectionSize() {
        return this.getAddsSize() + this.getMovesSize();
    }

    private int getRemoveIndex(int index) {
        return this.getRemoveIndexes()[index];
    }

    @Override
    public int[] getRemoveIndexes() {
        if (this.removeIndexes == null) {
            this.removeIndexes = new int[0];
        }
        return this.removeIndexes;
    }

    @Override
    public Vector getRemoves() {
        if (this.removes == null) {
            this.removes = new Vector(1);
        }
        return this.removes;
    }

    private int getRemovesIndexOf(Object changeSet) {
        if (this.removes == null) {
            return -1;
        }
        return this.removes.indexOf(changeSet);
    }

    private boolean hasAdds() {
        return this.addIndexes != null && this.addIndexes.length != 0;
    }

    @Override
    public boolean hasChanges() {
        if (this.hasAdds() || this.hasRemoves() || this.getOwner().isNew()) {
            return true;
        }
        if (this.hasMoves()) {
            int index = 0;
            while (index < this.moveIndexPairs.length) {
                if (this.moveIndexPairs[index][0] != this.moveIndexPairs[index][1]) {
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    private boolean hasMoves() {
        return this.moveIndexPairs != null && this.moveIndexPairs.length != 0;
    }

    private boolean hasRemoves() {
        return this.removeIndexes != null && this.removeIndexes.length != 0;
    }

    private int[] removeFrom(int removeIndex, int[] oldArray) {
        int oldCount = oldArray.length;
        int[] newArray = new int[oldCount - 1];
        System.arraycopy(oldArray, 0, newArray, 0, removeIndex);
        System.arraycopy(oldArray, removeIndex + 1, newArray, removeIndex, oldCount - removeIndex - 1);
        return newArray;
    }

    private int[][] removeFrom(int removeIndex, int[][] oldArray) {
        int oldCount = oldArray.length;
        int[][] newArray = new int[oldCount - 1][];
        System.arraycopy(oldArray, 0, newArray, 0, removeIndex);
        System.arraycopy(oldArray, removeIndex + 1, newArray, removeIndex, oldCount - removeIndex - 1);
        return newArray;
    }

    private void cancelAddedChangeSet(Object changeSet) {
        int changeSetIndex = this.getAddsIndexOf(changeSet);
        if (changeSetIndex == -1) {
            throw new IllegalStateException(changeSet.toString());
        }
        this.getAdds().remove(changeSetIndex);
        this.setAddIndexes(this.removeFrom(changeSetIndex, this.getAddIndexes()));
    }

    private boolean removeMovedChangeSet(Object changeSet) {
        int changeSetIndex = this.getMovesIndexOf(changeSet);
        if (changeSetIndex == -1) {
            return false;
        }
        this.getMoves().remove(changeSetIndex);
        int beforeMoveIndex = this.getBeforeMoveIndex(changeSetIndex);
        this.setMoveIndexPairs(this.removeFrom(changeSetIndex, this.getMoveIndexPairs()));
        this.addRemovedChangeSet(changeSet, beforeMoveIndex);
        return true;
    }

    private boolean restoreRemovedChangeSet(Object changeSet) {
        int changeSetIndex = this.getRemovesIndexOf(changeSet);
        if (changeSetIndex == -1) {
            return false;
        }
        this.getRemoves().remove(changeSetIndex);
        int removeIndex = this.getRemoveIndex(changeSetIndex);
        this.setRemoveIndexes(this.removeFrom(changeSetIndex, this.getRemoveIndexes()));
        this.addMovedChangeSet(changeSet, removeIndex, this.getNewCollectionSize());
        return true;
    }

    private void setAddIndexes(int[] addIndexes) {
        this.addIndexes = addIndexes;
    }

    private void setMoveIndexPairs(int[][] moveIndexPairs) {
        this.moveIndexPairs = moveIndexPairs;
    }

    private void setRemoveIndexes(int[] removeIndexes) {
        this.removeIndexes = removeIndexes;
    }

    public void simpleAddChangeSet(Object changeSet) {
        if (!this.restoreRemovedChangeSet(changeSet)) {
            this.addAddedChangeSet(changeSet, this.getNewCollectionSize());
        }
    }

    public void simpleRemoveChangeSet(Object changeSet) {
        if (!this.removeMovedChangeSet(changeSet)) {
            this.cancelAddedChangeSet(changeSet);
        }
    }
}

