/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.glassfish.jersey.server.monitoring.ExceptionMapperStatistics;

class ExceptionMapperStatisticsImpl
implements ExceptionMapperStatistics {
    private final Map<Class<?>, Long> exceptionMapperExecutionCount;
    private final long successfulMappings;
    private final long unsuccessfulMappings;
    private final long totalMappings;

    private ExceptionMapperStatisticsImpl(Map<Class<?>, Long> exceptionMapperExecutionCount, long successfulMappings, long unsuccessfulMappings, long totalMappings) {
        this.exceptionMapperExecutionCount = exceptionMapperExecutionCount;
        this.successfulMappings = successfulMappings;
        this.unsuccessfulMappings = unsuccessfulMappings;
        this.totalMappings = totalMappings;
    }

    @Override
    public Map<Class<?>, Long> getExceptionMapperExecutions() {
        return this.exceptionMapperExecutionCount;
    }

    @Override
    public long getSuccessfulMappings() {
        return this.successfulMappings;
    }

    @Override
    public long getUnsuccessfulMappings() {
        return this.unsuccessfulMappings;
    }

    @Override
    public long getTotalMappings() {
        return this.totalMappings;
    }

    @Override
    public ExceptionMapperStatistics snapshot() {
        return this;
    }

    static class Builder {
        private Map<Class<?>, Long> exceptionMapperExecutionCount = Maps.newHashMap();
        private long successfulMappings;
        private long unsuccessfulMappings;
        private long totalMappings;

        Builder() {
        }

        void addMapping(boolean success, int count) {
            ++this.totalMappings;
            if (success) {
                this.successfulMappings += (long)count;
            } else {
                this.unsuccessfulMappings += (long)count;
            }
        }

        void addExceptionMapperExecution(Class<?> mapper, int count) {
            Long cnt = this.exceptionMapperExecutionCount.get(mapper);
            cnt = cnt == null ? (long)count : cnt + (long)count;
            this.exceptionMapperExecutionCount.put(mapper, cnt);
        }

        public ExceptionMapperStatisticsImpl build() {
            return new ExceptionMapperStatisticsImpl(Collections.unmodifiableMap(this.exceptionMapperExecutionCount), this.successfulMappings, this.unsuccessfulMappings, this.totalMappings);
        }
    }
}

