/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.core.queries;

import java.io.Serializable;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.core.queries.CoreAttributeItem;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;

public class CoreAttributeGroup<ATTRIBUTE_ITEM extends CoreAttributeItem>
implements Serializable,
Cloneable {
    protected String name;
    protected String typeName;
    protected Class type;
    protected CoreAttributeGroup superClassGroup;
    protected transient Set<CoreAttributeGroup> subClasses;
    protected Map<Object, CoreAttributeGroup> allsubclasses;
    protected Map<String, ATTRIBUTE_ITEM> items;
    protected boolean isValidated;

    public CoreAttributeGroup(String name) {
        this.name = name;
    }

    public CoreAttributeGroup(String name, String type, boolean isValidated) {
        this(name);
        this.typeName = type;
        this.isValidated = isValidated;
    }

    public CoreAttributeGroup(String name, Class type, boolean isValidated) {
        this(name);
        this.type = type;
        this.isValidated = isValidated;
    }

    public CoreAttributeGroup() {
        this("");
    }

    public void addAttribute(String attributeNameOrPath) {
        this.addAttribute(attributeNameOrPath, (CoreAttributeGroup)null);
    }

    public void addAttribute(String attributeNameOrPath, Collection<? extends CoreAttributeGroup> groups) {
        ATTRIBUTE_ITEM item = this.getItem(this.convert(attributeNameOrPath), true);
        ((CoreAttributeItem)item).addGroups(groups);
    }

    public void addAttribute(String attributeNameOrPath, CoreAttributeGroup group) {
        ATTRIBUTE_ITEM item = this.getItem(this.convert(attributeNameOrPath), true);
        ((CoreAttributeItem)item).addSubGroup((CoreAttributeGroup)group);
    }

    public void addAttributeKey(String attributeNameOrPath, CoreAttributeGroup group) {
        ATTRIBUTE_ITEM item = this.getItem(this.convert(attributeNameOrPath), true);
        ((CoreAttributeItem)item).addKeyGroup((CoreAttributeGroup)group);
    }

    public void addAttributes(Collection<String> attrOrPaths) {
        for (String attr : attrOrPaths) {
            this.addAttribute(attr);
        }
    }

    public CoreAttributeGroup clone() {
        IdentityHashMap<CoreAttributeGroup<ATTRIBUTE_ITEM>, CoreAttributeGroup<ATTRIBUTE_ITEM>> cloneMap = new IdentityHashMap<CoreAttributeGroup<ATTRIBUTE_ITEM>, CoreAttributeGroup<ATTRIBUTE_ITEM>>();
        return this.clone(cloneMap);
    }

    public CoreAttributeGroup clone(Map<CoreAttributeGroup<ATTRIBUTE_ITEM>, CoreAttributeGroup<ATTRIBUTE_ITEM>> cloneMap) {
        CoreAttributeGroup clone = cloneMap.get(this);
        if (clone != null) {
            return clone;
        }
        try {
            clone = (CoreAttributeGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.name = this.name;
        clone.type = this.type;
        clone.typeName = this.typeName;
        clone.isValidated = this.isValidated;
        cloneMap.put(this, clone);
        if (this.allsubclasses != null) {
            for (CoreAttributeGroup group : this.allsubclasses.values()) {
                clone.getSubClassGroups().put(group.getType(), group.clone(cloneMap));
            }
        }
        if (this.superClassGroup != null) {
            clone.superClassGroup = this.superClassGroup.clone(cloneMap);
        }
        if (this.subClasses != null) {
            clone.subClasses = new HashSet<CoreAttributeGroup>();
            for (CoreAttributeGroup group : this.subClasses) {
                clone.subClasses.add(group.clone(cloneMap));
            }
        }
        clone.items = null;
        if (this.hasItems()) {
            clone.items = new HashMap<String, ATTRIBUTE_ITEM>();
            for (CoreAttributeItem item : this.items.values()) {
                clone.items.put(item.getAttributeName(), item.clone(cloneMap, clone));
            }
        }
        return clone;
    }

    public boolean containsAttribute(String attributeNameOrPath) {
        String[] path = this.convert(attributeNameOrPath);
        if (this.getItem(path, false) != null) {
            return true;
        }
        if (this.hasInheritance() && this.superClassGroup != null) {
            return this.superClassGroup.containsAttribute(attributeNameOrPath);
        }
        return false;
    }

    public boolean containsAttributeInternal(String attributeName) {
        if (this.items != null && this.items.containsKey(attributeName)) {
            return true;
        }
        if (this.hasInheritance() && this.superClassGroup != null) {
            return this.superClassGroup.containsAttributeInternal(attributeName);
        }
        return false;
    }

    protected String[] convert(String ... nameOrPath) {
        if (nameOrPath == null || nameOrPath.length == 0 || nameOrPath.length == 1 && (nameOrPath[0] == null || nameOrPath[0].length() == 0)) {
            throw new IllegalArgumentException("Inavlid name or path: " + (nameOrPath.length == 1 ? nameOrPath[0] : null));
        }
        String[] path = nameOrPath;
        if (nameOrPath.length > 1 || !nameOrPath[0].contains(".")) {
            path = nameOrPath;
        } else {
            if (nameOrPath[0].endsWith(".")) {
                throw new IllegalArgumentException("Invalid path: " + nameOrPath[0]);
            }
            path = nameOrPath[0].split("\\.");
        }
        if (path.length == 0) {
            throw new IllegalArgumentException("Invalid path: " + nameOrPath[0]);
        }
        int index = 0;
        while (index < path.length) {
            if (path[index] == null || path[index].length() == 0 || !path[index].trim().equals(path[index])) {
                throw new IllegalArgumentException("Invalid path: " + nameOrPath[0]);
            }
            ++index;
        }
        return path;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.type == null) {
            block11: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            this.type = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.typeName, true, classLoader));
                            break block11;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.typeName, exception.getException());
                        }
                    }
                    this.type = PrivilegedAccessHelper.getClassForName(this.typeName, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.typeName, exc);
                }
            }
            if (this.items != null) {
                for (CoreAttributeItem item : this.items.values()) {
                    item.convertClassNamesToClasses(classLoader);
                }
            }
            if (this.allsubclasses != null) {
                HashMap<Object, CoreAttributeGroup> allGroups = new HashMap<Object, CoreAttributeGroup>();
                this.subClasses = new HashSet<CoreAttributeGroup>();
                for (CoreAttributeGroup subClass : this.allsubclasses.values()) {
                    subClass.convertClassNamesToClasses(classLoader);
                    allGroups.put(subClass.getType(), subClass);
                }
                this.allsubclasses = allGroups;
                for (CoreAttributeGroup subClass : this.allsubclasses.values()) {
                    if (!AttributeItem.orderInheritance(subClass, allGroups)) continue;
                    this.insertSubClass(subClass);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) {
            return false;
        }
        CoreAttributeGroup anotherGroup = null;
        try {
            anotherGroup = (CoreAttributeGroup)obj;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (this.hasItems()) {
            if (!anotherGroup.hasItems()) return false;
            if (!this.getItems().equals(anotherGroup.getItems())) {
                return false;
            }
        } else if (anotherGroup.hasItems()) {
            return false;
        }
        if (this.superClassGroup == null) return anotherGroup.superClassGroup == null;
        if (anotherGroup.superClassGroup == null) return false;
        return this.superClassGroup.equals(anotherGroup.superClassGroup);
    }

    public CoreAttributeGroup findGroup(ClassDescriptor type) {
        if (this.type == null || this.type.equals(type.getJavaClass())) {
            return this;
        }
        if (this.hasInheritance()) {
            CoreAttributeGroup result = this.getSubClassGroups().get(type.getJavaClass());
            while (result == null && type.getInheritancePolicy().getParentDescriptor() != null) {
                type = type.getInheritancePolicy().getParentDescriptor();
                result = this.getSubClassGroups().get(type.getJavaClass());
            }
            if (result != null) {
                return result;
            }
        }
        return this;
    }

    public Map<String, ATTRIBUTE_ITEM> getAllItems() {
        HashMap<String, ATTRIBUTE_ITEM> allItems = new HashMap<String, ATTRIBUTE_ITEM>();
        if (this.superClassGroup != null) {
            allItems.putAll(this.superClassGroup.getAllItems());
        }
        allItems.putAll(this.getItems());
        return allItems;
    }

    public Set<String> getAttributeNames() {
        HashSet<String> attributes = new HashSet<String>();
        if (this.superClassGroup != null && this.superClassGroup != this) {
            attributes.addAll(this.superClassGroup.getAttributeNames());
        }
        attributes.addAll(this.getItems().keySet());
        return attributes;
    }

    public CoreAttributeGroup getGroup(String attributeNameOrPath) {
        ATTRIBUTE_ITEM item = this.getItem(this.convert(attributeNameOrPath), false);
        if (item != null) {
            return ((CoreAttributeItem)item).getGroup();
        }
        if (this.hasInheritance()) {
            return this.superClassGroup.getGroup(attributeNameOrPath);
        }
        return null;
    }

    public ATTRIBUTE_ITEM getItem(String attributeNameOrPath) {
        return this.getItem(this.convert(attributeNameOrPath), false);
    }

    protected ATTRIBUTE_ITEM getItem(String[] attributePath, boolean create) {
        CoreAttributeItem item = null;
        CoreAttributeGroup<Object> currentGroup = this;
        int index = 0;
        while (index < attributePath.length) {
            String attrName = attributePath[index];
            item = (CoreAttributeItem)currentGroup.getItems().get(attrName);
            if (item == null) {
                if (!create) {
                    if (this.superClassGroup != null) {
                        return this.superClassGroup.getItem(attributePath, create);
                    }
                    return null;
                }
                item = this.newItem(currentGroup, attrName);
                currentGroup.getItems().put(attrName, item);
            }
            if (item.getGroup() == null && index < attributePath.length - 1) {
                if (!create) {
                    return null;
                }
                CoreAttributeGroup newGroup = this.newGroup(attrName, currentGroup);
                item.setRootGroup(newGroup);
            }
            currentGroup = item.getGroup();
            ++index;
        }
        return (ATTRIBUTE_ITEM)item;
    }

    public Map<String, ATTRIBUTE_ITEM> getItems() {
        if (this.items == null) {
            this.items = new HashMap<String, ATTRIBUTE_ITEM>();
        }
        return this.items;
    }

    public String getName() {
        return this.name;
    }

    public Map<Object, CoreAttributeGroup> getSubClassGroups() {
        if (this.allsubclasses == null) {
            this.allsubclasses = new HashMap<Object, CoreAttributeGroup>();
        }
        return this.allsubclasses;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean hasInheritance() {
        return this.subClasses != null && !this.subClasses.isEmpty() || this.superClassGroup != null;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public void insertSubClass(CoreAttributeGroup group) {
        if (this == group) {
            return;
        }
        group.superClassGroup = this;
        if (this.subClasses != null) {
            Iterator<CoreAttributeGroup> subClasses = this.subClasses.iterator();
            while (subClasses.hasNext()) {
                CoreAttributeGroup subClass = subClasses.next();
                if (group == subClass || !group.getType().isAssignableFrom(subClass.getType())) continue;
                group.subClasses.add(subClass);
                subClass.superClassGroup = group;
                subClasses.remove();
            }
        } else {
            this.subClasses = new HashSet<CoreAttributeGroup>();
        }
        this.subClasses.add(group);
    }

    public boolean isConcurrent() {
        return false;
    }

    public boolean isCopyGroup() {
        return false;
    }

    public boolean isFetchGroup() {
        return false;
    }

    public boolean isLoadGroup() {
        return false;
    }

    public boolean isSupersetOf(CoreAttributeGroup<ATTRIBUTE_ITEM> anotherGroup) {
        if (anotherGroup == null) {
            return false;
        }
        if (anotherGroup != this) {
            if (this.hasItems()) {
                if (anotherGroup.hasItems()) {
                    for (Map.Entry<String, ATTRIBUTE_ITEM> otherItemEntry : anotherGroup.getItems().entrySet()) {
                        CoreAttributeGroup otherElement;
                        CoreAttributeGroup element;
                        String otherAttributeName = otherItemEntry.getKey();
                        CoreAttributeItem item = (CoreAttributeItem)this.items.get(otherAttributeName);
                        if (item == null) {
                            return false;
                        }
                        Object group = item.getGroup();
                        Object otherGroup = ((CoreAttributeItem)otherItemEntry.getValue()).getGroup();
                        if (group != null) {
                            if (!((CoreAttributeGroup)group).isSupersetOf((CoreAttributeGroup<ATTRIBUTE_ITEM>)otherGroup)) {
                                return false;
                            }
                        } else if (otherGroup != null) {
                            return true;
                        }
                        group = item.getKeyGroup();
                        otherGroup = ((CoreAttributeItem)otherItemEntry.getValue()).getKeyGroup();
                        if (group != null) {
                            if (!((CoreAttributeGroup)group).isSupersetOf((CoreAttributeGroup<ATTRIBUTE_ITEM>)otherGroup)) {
                                return false;
                            }
                        } else if (otherGroup != null) {
                            return true;
                        }
                        if (item.getGroups() != null) {
                            if (((CoreAttributeItem)otherItemEntry.getValue()).getGroups() == null) {
                                return true;
                            }
                            for (Object next : item.getGroups().values()) {
                                element = (CoreAttributeGroup)next;
                                if (element.isSupersetOf(otherElement = (CoreAttributeGroup)((CoreAttributeItem)otherItemEntry.getValue()).getGroups().get(element.getType()))) continue;
                                return false;
                            }
                        }
                        if (item.getKeyGroups() == null) continue;
                        if (((CoreAttributeItem)otherItemEntry.getValue()).getKeyGroups() == null) {
                            return true;
                        }
                        for (Object next : item.getKeyGroups().values()) {
                            element = (CoreAttributeGroup)next;
                            if (element.isSupersetOf(otherElement = (CoreAttributeGroup)((CoreAttributeItem)otherItemEntry.getValue()).getKeyGroups().get(element.getType()))) continue;
                            return false;
                        }
                    }
                    return true;
                }
                return true;
            }
            return !anotherGroup.hasItems();
        }
        return true;
    }

    public boolean isValidated() {
        return this.isValidated;
    }

    protected CoreAttributeGroup newGroup(String name, CoreAttributeGroup parent) {
        return new CoreAttributeGroup<ATTRIBUTE_ITEM>(name);
    }

    protected CoreAttributeItem newItem(CoreAttributeGroup group, String attrName) {
        return new CoreAttributeItem<CoreAttributeGroup>(group, attrName);
    }

    public void removeAttribute(String attributeNameOrPath) {
        ATTRIBUTE_ITEM item = this.getItem(attributeNameOrPath);
        if (item != null) {
            ((CoreAttributeGroup)((CoreAttributeItem)item).getParent()).getItems().remove(((CoreAttributeItem)item).getAttributeName());
        }
    }

    public void setAllSubclasses(Map<Object, CoreAttributeGroup> subclasses) {
        this.allsubclasses = subclasses;
    }

    public void setAttributeNames(Set attributeNames) {
        Iterator it = attributeNames.iterator();
        while (it.hasNext()) {
            this.addAttribute((String)it.next());
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.getName() + ")" + this.toStringAdditionalInfo() + "{" + this.toStringItems() + "}";
    }

    protected String toStringAdditionalInfo() {
        return "";
    }

    protected String toStringItems() {
        String str = "";
        if (this.items != null) {
            Iterator<ATTRIBUTE_ITEM> it = this.items.values().iterator();
            boolean isFirst = true;
            while (it.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    str = String.valueOf(str) + ", ";
                }
                str = String.valueOf(str) + ((CoreAttributeItem)it.next()).toStringNoClassName();
            }
        }
        if (this.superClassGroup != null) {
            str = String.valueOf(str) + ", " + this.superClassGroup.toStringItems();
        }
        return str;
    }

    protected static String toStringPath(String[] attributePath, int position) {
        StringWriter writer = new StringWriter();
        int index = 0;
        while (index <= position) {
            writer.write(attributePath[index]);
            if (index < position) {
                writer.write(".");
            }
            ++index;
        }
        return writer.toString();
    }
}

