/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import com.sun.tools.xjc.DTDXtoXJS;
import com.sun.tools.xjc.UserErrorException;
import com.sun.tools.xjc.Version;
import com.sun.tools.xjc.XJStoXJB;
import com.sun.tools.xjc.be.Gen;
import com.sun.tools.xjc.dtd.DTDParser;
import com.sun.tools.xjc.dtd.parser.DTDParseException;
import com.sun.tools.xjc.dtdx.DTDX;
import com.sun.tools.xjc.xjb.XJB;
import com.sun.tools.xjc.xjs.XJS;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.ValidationException;

public class Main {
    private static boolean verbose = false;
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;
    private static final File STDOUT = new File("-");
    private static final int OP_UNDEFINED = -1;
    private static final int OP_COMPILE = 0;
    private static final int OP_GEN_DTDX = 1;
    private static final int OP_GEN_XJB = 2;
    private static final int OP_GEN_XJS = 3;
    private static final String[][] internalOptions = new String[][]{{"-dtdx", "<target-dtdx>", "Translate a DTD into DTDX"}, {"-xjs", "<target-xjs>", "Generate the default xjs into <target-xjs>"}, {"-xjb", "<target-xjb>", "Generate a default binding schema into <target-xjb>"}, {"-verbose", "", "Enable verbose output"}};
    private static final String[][] options = new String[][]{{"-d", "<directory>", "Specify the destination directory for the Java output"}, {"-roots", "<element-list>", "Designate one or more root elements (comma separated)"}, {"-version", "", "Print the compiler's version number and exit"}, {"-help", "", "Print this message and exit"}};

    private static OutputStream openOut(File file) throws IOException {
        if (file == STDOUT) {
            return System.out;
        }
        if (file.exists() && !file.delete()) {
            throw new IOException(file + "Can't delete previous version");
        }
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    private static void exit(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Error: ");
        String string = exception.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        if (string.endsWith("Exception")) {
            string = string.substring(0, string.length() - 9);
        }
        stringBuffer.append(string);
        String string2 = exception.getMessage();
        if (string2 != null) {
            stringBuffer.append(": ");
            stringBuffer.append(string2);
        }
        err.println(stringBuffer.toString());
        System.exit(1);
    }

    private static void doCompile(File file, File file2, File file3, List list) throws DTDParseException, IOException, UnmarshalException {
        DTDX dTDX = DTDParser.parse(file);
        XJS xJS = null;
        if (file2 != null) {
            xJS = XJS.unmarshal(new FileInputStream(file2));
            xJS.validate();
        }
        xJS = DTDXtoXJS.generate(dTDX, xJS, list);
        dTDX = DTDParser.parse(file);
        XJB xJB = XJStoXJB.generate(dTDX, xJS);
        Gen.compile(xJB, file3);
    }

    public static void compile(File file, File file2, File file3, List list) {
        try {
            try {
                Main.doCompile(file, file2, file3, list);
            }
            catch (UserErrorException userErrorException) {
                Main.exit(userErrorException);
            }
            catch (DTDParseException dTDParseException) {
                Main.exit(dTDParseException);
            }
            catch (IOException iOException) {
                Main.exit(iOException);
            }
            catch (UnmarshalException unmarshalException) {
                Main.exit(unmarshalException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (unsupportedOperationException.getMessage().equals("any")) {
                    Main.exit(unsupportedOperationException);
                }
            }
        }
        catch (Throwable throwable) {
            err.println();
            err.println("An error has occurred in the JAXB compiler.");
            err.println("Please submit a bug report to jaxb-feedback@java.sun.com");
            err.println("containing your input files as well as the output below.");
            err.println();
            throwable.printStackTrace(err);
            err.println();
            Version.show(err);
        }
    }

    public static void genDTDX(File file, File file2) throws DTDParseException, IOException, ValidationException {
        block2: {
            DTDX dTDX = DTDParser.parse(file);
            try {
                dTDX.marshal(Main.openOut(file2));
            }
            catch (IOException iOException) {
                if (file2 == STDOUT) break block2;
                file2.delete();
            }
        }
    }

    public static void genXJS(File file, File file2, File file3, List list) throws DTDParseException, IOException, UnmarshalException, ValidationException {
        DTDX dTDX = DTDParser.parse(file);
        XJS xJS = null;
        if (file2 != null) {
            xJS = XJS.unmarshal(new FileInputStream(file2));
            xJS.validate();
        }
        xJS = DTDXtoXJS.generate(dTDX, xJS, list);
        try {
            xJS.marshal(Main.openOut(file3));
        }
        catch (IOException iOException) {
            if (file2 != null && file2 != STDOUT) {
                file2.delete();
            }
            throw iOException;
        }
    }

    public static void genXJB(File file, File file2, File file3, List list) throws DTDParseException, IOException, UnmarshalException, ValidationException {
        block3: {
            DTDX dTDX = DTDParser.parse(file);
            XJS xJS = null;
            if (file2 != null) {
                xJS = XJS.unmarshal(new FileInputStream(file2));
                xJS.validate();
            }
            xJS = DTDXtoXJS.generate(dTDX, xJS, list);
            dTDX = DTDParser.parse(file);
            XJB xJB = XJStoXJB.generate(dTDX, xJS);
            try {
                xJB.marshal(Main.openOut(file3));
            }
            catch (IOException iOException) {
                if (file3 == STDOUT) break block3;
                file3.delete();
            }
        }
    }

    private static File parseTarget(String string) {
        if (string.equals("-")) {
            return STDOUT;
        }
        if (string.startsWith("-")) {
            Main.usage(1);
        }
        return new File(string);
    }

    private static List parseRoots(String string) {
        if (string.startsWith("-")) {
            Main.usage(1);
        }
        if (string.lastIndexOf(",") == string.length() - 1) {
            Main.usage(1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(",", n)) != -1) {
            arrayList.add(string.substring(n, n2));
            n = n2 + 1;
        }
        arrayList.add(string.substring(n));
        return arrayList;
    }

    public static void main(String[] stringArray) throws Exception {
        File file = null;
        File file2 = null;
        File file3 = null;
        File file4 = null;
        List list = null;
        int n = -1;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            if (string.startsWith("--")) {
                string = string.substring(1);
            }
            if (string.equals("-xjb") && n3 < n2 - 1) {
                if (n != -1) {
                    Main.usage(1);
                }
                n = 2;
                file3 = Main.parseTarget(stringArray[++n3]);
            } else if (string.equals("-dtdx") && n3 < n2 - 1) {
                if (n != -1) {
                    Main.usage(1);
                }
                n = 1;
                file3 = Main.parseTarget(stringArray[++n3]);
            } else if (string.equals("-xjs") && n3 < n2 - 1) {
                if (n != -1) {
                    Main.usage(1);
                }
                n = 3;
                file3 = Main.parseTarget(stringArray[++n3]);
            } else if (string.equals("-d") && n3 < n2 - 1) {
                if (n != -1) {
                    Main.usage(1);
                }
                n = 0;
                file4 = Main.parseTarget(stringArray[++n3]);
            } else if ((string.equals("-roots") || string.equals("-r")) && n3 < n2 - 1) {
                list = Main.parseRoots(stringArray[++n3]);
            } else if (string.equals("-verbose")) {
                verbose = true;
            } else if (string.equals("-version")) {
                Version.show(System.out);
                System.exit(0);
            } else if (string.equals("-help")) {
                Main.usage(0);
            } else if (string.startsWith("-")) {
                Main.usage(1);
            } else if (file == null) {
                file = new File(string);
            } else if (file2 == null) {
                file2 = new File(string);
            } else {
                Main.usage(2);
            }
            ++n3;
        }
        if (n == -1) {
            if (file == null) {
                Main.usage(1);
            }
            n = 0;
            if (file4 == null) {
                file4 = new File(".");
            }
        }
        if (n != 0 && file4 != null) {
            Main.usage(1);
        }
        if (n == 1 && list != null) {
            Main.usage(1);
        }
        if (list != null && file2 != null) {
            Main.usage(1);
        }
        switch (n) {
            case 0: {
                Main.compile(file, file2, file4, list);
                break;
            }
            case 1: {
                Main.genDTDX(file, file3);
                break;
            }
            case 2: {
                Main.genXJB(file, file2, file3, list);
                break;
            }
            case 3: {
                Main.genXJS(file, file2, file3, list);
                break;
            }
            default: {
                out.println("Argument processing complete, requested action not supported");
                out.println("f1         " + file);
                out.println("f2         " + file2);
                out.println("target     " + file3);
                out.println("targetDir  " + file4);
                out.println("roots      " + list);
                out.println("op         " + (new String[]{"UNDEF", "compile", "gen-dtdx", "gen-xjb", "gen-xjs"})[n + 1]);
            }
        }
    }

    private static void usage(int n) {
        err.println("Usage: xjc <schema> [ <binding-schema> ] [ -d <directory> ]");
        err.println("           [ -roots <element-list> ]");
        err.println("Options:");
        int n2 = 0;
        while (n2 < options.length) {
            String string = "  " + options[n2][0] + " " + options[n2][1];
            err.print(string);
            int n3 = string.length();
            while (n3 < 25) {
                err.print(" ");
                ++n3;
            }
            err.println(options[n2][2]);
            ++n2;
        }
        System.exit(n);
    }
}

