/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.IOException;
import javax.xml.bind.MarshallableObject;
import javax.xml.bind.MarshallableRootElement;
import javax.xml.bind.ValidationRequiredException;
import javax.xml.marshal.XMLWriter;

public final class Marshaller {
    private XMLWriter writer;

    Marshaller(XMLWriter xMLWriter) {
        this.writer = xMLWriter;
    }

    private void ensureNotFinished() {
        if (this.writer == null) {
            throw new IllegalStateException("Marshaller previously used");
        }
    }

    public XMLWriter writer() {
        return this.writer;
    }

    public void marshal(MarshallableObject marshallableObject) throws IOException {
        this.ensureNotFinished();
        if (marshallableObject.needsValidation()) {
            throw new ValidationRequiredException();
        }
        marshallableObject.marshal(this);
    }

    void marshalRoot(MarshallableRootElement marshallableRootElement) throws IOException {
        this.marshal(marshallableRootElement);
        this.writer.flush();
        this.writer = null;
    }
}

