/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.querydef.CommonAbstractCriteriaImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.SubQueryImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.sessions.Project;

public class ExpressionImpl<X>
extends SelectionImpl<X>
implements Expression<X>,
InternalExpression {
    protected Metamodel metamodel;
    protected boolean isLiteral;
    protected Object literal;

    protected ExpressionImpl(Metamodel metamodel, Class<X> javaType, org.eclipse.persistence.expressions.Expression expressionNode) {
        super(javaType, expressionNode);
        this.metamodel = metamodel;
    }

    public ExpressionImpl(Metamodel metamodel, Class<X> javaType, org.eclipse.persistence.expressions.Expression expressionNode, Object value) {
        super(javaType, expressionNode);
        this.metamodel = metamodel;
        this.literal = value;
        this.isLiteral = true;
    }

    @Override
    public <T> Expression<T> as(Class<T> type) {
        ClassDescriptor descriptor;
        Project project = ((MetamodelImpl)this.metamodel).getProject();
        if (project != null && (descriptor = project.getClassDescriptor(this.javaType)) != null && descriptor.hasInheritance() && (descriptor = descriptor.getInheritancePolicy().getSubclassDescriptor(type)) != null) {
            return this.buildExpressionForAs(type);
        }
        return this;
    }

    protected <T> Expression<T> buildExpressionForAs(Class<T> type) {
        return this;
    }

    @Override
    public Predicate in(Object ... values) {
        ArrayList list = new ArrayList();
        list.add(this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.in(values), list, "in");
    }

    @Override
    public Predicate in(Expression<?> ... values) {
        if (values != null) {
            ArrayList list = new ArrayList();
            list.add(this);
            if (values.length == 1 && ((InternalExpression)((Object)values[0])).isSubquery()) {
                list.add(values[0]);
                return new CompoundExpressionImpl(this.metamodel, this.currentNode.in(((SubQueryImpl)values[0]).subQuery), list, "in");
            }
            ArrayList<org.eclipse.persistence.expressions.Expression> inValues = new ArrayList<org.eclipse.persistence.expressions.Expression>();
            Expression<?>[] expressionArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Expression<?> exp = expressionArray[n2];
                if (!((InternalExpression)((Object)exp)).isLiteral() && !((InternalExpression)((Object)exp)).isParameter()) {
                    Object[] params = new Object[]{exp};
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("CRITERIA_NON_LITERAL_PASSED_TO_IN", params));
                }
                list.add(exp);
                inValues.add(((InternalSelection)((Object)exp)).getCurrentNode());
                ++n2;
            }
            return new CompoundExpressionImpl(this.metamodel, this.currentNode.in(inValues), list, "in");
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NULL_PASSED_TO_EXPRESSION_IN"));
    }

    @Override
    public Predicate in(Collection<?> values) {
        ArrayList<ExpressionImpl> list = new ArrayList<ExpressionImpl>();
        list.add(this);
        return new InImpl(this.metamodel, this, values, list);
    }

    @Override
    public Predicate in(Expression<Collection<?>> values) {
        ArrayList list = new ArrayList();
        list.add(values);
        list.add(this);
        return new InImpl(this.metamodel, this, (ExpressionImpl)values, list);
    }

    @Override
    public Predicate isNotNull() {
        ArrayList list = new ArrayList();
        list.add(this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.notNull(), list, "not null");
    }

    @Override
    public Predicate isNull() {
        ArrayList list = new ArrayList();
        list.add(this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.isNull(), list, "is null");
    }

    @Override
    public boolean isPredicate() {
        return false;
    }

    @Override
    public boolean isSubquery() {
        return false;
    }

    @Override
    public boolean isCompoundExpression() {
        return false;
    }

    @Override
    public boolean isExpression() {
        return true;
    }

    @Override
    public boolean isJunction() {
        return false;
    }

    @Override
    public boolean isLiteral() {
        return this.isLiteral;
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public void findRootAndParameters(CommonAbstractCriteriaImpl criteriaQuery) {
    }
}

