/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.gen;

import com.sun.tools.xjc.gen.Class;
import com.sun.tools.xjc.gen.CodeWriter;
import com.sun.tools.xjc.gen.Declaration;
import com.sun.tools.xjc.gen.DefinedClass;
import com.sun.tools.xjc.gen.Formatter;
import com.sun.tools.xjc.gen.Generable;
import com.sun.tools.xjc.gen.PackageMemberClass;
import com.sun.tools.xjc.gen.ReferencedClass;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class Package
implements Declaration,
Generable {
    public static final Package LANG = new Package("java.lang");
    public static final Package IO = new Package("java.io");
    public static final Package NET = new Package("java.net");
    public static final Package UTIL = new Package("java.util");
    private String name;
    private CodeWriter codeWriter;
    private TreeSet classes = new TreeSet();

    static void addBuiltinPackages(Map map) {
        map.put("java.lang", LANG);
        map.put("java.io", IO);
        map.put("java.net", NET);
        map.put("java.util", UTIL);
    }

    private Package(String string) {
        this.name = string;
        this.codeWriter = null;
    }

    Package(String string, CodeWriter codeWriter) {
        this.codeWriter = codeWriter;
        if (string.equals(".")) {
            String string2 = "Package name . is not allowed";
            throw new IllegalArgumentException(string2);
        }
        int n = 1;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '.') {
                ++n;
            } else {
                if (n > 1) {
                    String string3 = "Package name " + string + " missing identifier";
                    throw new IllegalArgumentException(string3);
                }
                if (n == 1 && !Character.isJavaIdentifierStart(c)) {
                    String string4 = "Package name " + string + " contains illegal " + "character for beginning of identifier: " + c;
                    throw new IllegalArgumentException(string4);
                }
                if (!Character.isJavaIdentifierPart(c)) {
                    String string5 = "Package name " + string + "contains illegal " + "character: " + c;
                    throw new IllegalArgumentException(string5);
                }
                n = 0;
            }
            ++n2;
        }
        if (!string.trim().equals("") && n != 0) {
            String string6 = "Package name not allowed to end with .";
            throw new IllegalArgumentException(string6);
        }
        this.name = string;
    }

    public DefinedClass _class(int n, String string) {
        PackageMemberClass packageMemberClass = new PackageMemberClass(this, n, string);
        this.classes.add(packageMemberClass);
        return packageMemberClass;
    }

    public DefinedClass _interface(int n, String string) {
        PackageMemberClass packageMemberClass = new PackageMemberClass(this, n, string, true);
        this.classes.add(packageMemberClass);
        return packageMemberClass;
    }

    public Class ref(String string) {
        if (string.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Class name contains '.': " + string);
        }
        return new ReferencedClass(this, string, false);
    }

    public Iterator classes() {
        return this.classes.iterator();
    }

    public boolean isUnnamed() {
        return this.name.length() == 0;
    }

    public String name() {
        return this.name;
    }

    public CodeWriter codeWriter() {
        return this.codeWriter;
    }

    File toPath(File file) {
        if (this.name == null) {
            return file;
        }
        return new File(file, this.name.replace('.', File.separatorChar));
    }

    public void declare(Formatter formatter) {
        if (this.name.length() != 0) {
            formatter.p("package").p(this.name).p(';').nl();
        }
    }

    public void generate(Formatter formatter) {
        formatter.p(this.name);
    }

    private File sourceFileName(File file, DefinedClass definedClass) throws IOException {
        if (!file.isDirectory()) {
            throw new FileNotFoundException("Directory '" + file + "' does not exist");
        }
        File file2 = this.toPath(file);
        if (file2.exists() ? !file2.isDirectory() : !file2.mkdirs()) {
            throw new IOException("Unable to create directory '" + file2 + "'");
        }
        return new File(file2, definedClass.name() + ".java");
    }

    void build(File file) throws IOException {
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            DefinedClass definedClass = (DefinedClass)iterator.next();
            File file2 = this.sourceFileName(file, definedClass);
            System.out.println(file2);
            if (file2.exists() && !file2.delete()) {
                throw new IOException(file2 + ": Can't delete previous version");
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            Formatter formatter = new Formatter(new PrintWriter(bufferedWriter));
            definedClass.declare(formatter);
            formatter.close();
        }
    }
}

